# @(#)60   1.25   src/csm/install/pkgdefs/Linux.pm.perl, setup, csm_rameh, rameh0431a 6/29/04 06:25:17
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

package Linux;

#--------------------------------------------------------------------------------

=head3  Linux.pm.perl

        Package Definition File:   Linux

	Top level definition file for Linux platforms

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        EXCEPTIONS:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.


	NOTES on the PKGDEFS DESIGN:

	This isn't very well documented, so here are some notes to make
	working with these files eaiser the first few times.

	1. The first thing to recognize is that the data is just a lot 
	   of references to arrays.  The data is always an array; there
	   are no exceptions to this.  It may be an array of hashes but
	   its still just an array.

        2. Unfortunately, the names for these references need to be
	   unique.  This is most true for a pattern like:

		$ref{x}{y} = ['z'].

	   when it is processed by the "do" command more than once,
	   (e.g. an application tries to create both a node and server
	   registry for the same distro).  The explination for this
	   restiction is buried in the "do" file loader and perl
	   interpreter.  A good perl programmer probably knows why,
	   but so far this behavior is a bit of a mystery.

	3. $::mgmt_type has the value 'MgdNode or 'MgmtServer'
	   $::csm_version is as one would expect.  When an aray ref
	   is assigned to the global $::pkgdefs hash either the sever
	   or node type is selected for the assignment by the clever
	   way that the assignment statement is constructed.  This
	   assignment trick is a critical element of the design.
	
	FILES:

	The package defs files are loaded into the running process in the
	getPkgdef_files subroutine (or whatever it is called these days)
	usng the perl "do" command.  "do" reloads files with every invocation.
	The strategy is to find the correct distribution file, such as
	"Linux-RedHat7.3.pm" which also runs do to load Linux.pm.  That's
	pretty much it.


	SUGGESTIONS:

	DON'T PUT GLOBALS IN THE PKGDEFS FILE - just a suggestion. 
	Globals in these files makes things overly complex and can have
	weird side effects that are hard to find.   "do" has some error
	checking but it just ain't that good.  The point is that these
	files are simple; you don't need to get tricky - just assign
	an array reference to %::pkgdefs.


	PATTERNS:

	# 1
	my $a_ref	   = [ 'a', 'b' ];
	$::pkgdefs{ name } = $a_ref;

	# 2
	my $a_ref;
	$a_ref { $_server_ }	= [ 'a', 'b' ];
	$a_ref { $_node_   }	= [ 'b', 'c' ];
	$::pkgdefs{  name }	= $a_ref { $::mgmt_type };

	# 3 - reference name must be unique 
	my $b_ref;
	$b_ref { $_server_ }{$::csm_version} = [ 'a', 'b' ];
	$b_ref { $_node_   }{$::csm_version} = [ 'c', 'd' ];
	$::pkgdefs{ name }	
	    = $b_ref { $::mgmt_type } {$::csm_version};

	# 4 - hash array
	my $h_ref;
	$h_ref = [
		    { w => 'a'},
		    { x => 'b'},
		    { y => 'c'},
                 ];
	$::pkgdefs{ name } = $h_ref;

=cut

#--------------------------------------------------------------------------------

# housekeeping

NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall', 'V',
                          'IMsgLoading', "/opt/csm/install/pkgdefs/Linux.pm");

# wipe out pkgdefs global
%::pkgdefs = ();

# set for easy reading and typing
my $_server_ = 'MgmtServer';
my $_node_   = 'MgdNode';

#--------------------------------------------------------------------------------

=head3	csm_bin_copy_csm

	CSM binaries copied to /csminstall/csm directory

	Notes :

=cut

#--------------------------------------------------------------------------------
{

    my $a_ref = [
                 '/opt/csm/csmbin/updatenode.client',
                 '/opt/csm/csmbin/nodestatus.client',
                 '/opt/csm/csmbin/write_status',
                 '/opt/csm/msgmaps/csmInstall.csminstall.map',
                 '/opt/csm/pm/MessageUtils.pm',
                 '/opt/csm/pm/NodeUtils.pm',
                 '/opt/csm/pm/ArchiveUtils.pm',
                 '/opt/csm/pm/InstallUtils.pm',
                 '/opt/csm/pm/InstallKRB5Utils.pm',
                 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
                 '/opt/csm/pm/NetworkUtils.pm',
                 '/opt/csm/pm/ServerUtils.pm',
                 '/opt/csm/pm/CSMDefs.pm',
                 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                 '/opt/csm/csmbin/rmnode_client',
                 '/opt/csm/bin/setupconsole',
                 '/opt/csm/csmbin/makenode',
                 '/opt/csm/csmbin/csmprereboot',
                 '/opt/csm/csmbin/csmfirstboot',
                 '/opt/csm/install/defs',
                 '/opt/csm/install/pkgdefs'
                 ];

    $::pkgdefs{csm_bin_copy_csm} = $a_ref;

}

#--------------------------------------------------------------------------------

=head3	csm_bin_copy_tftpboot

	CSM binaries copied to /tftpboot directory
	Notes :

=cut

#--------------------------------------------------------------------------------
{

    my $a_ref = ['/usr/lib/syslinux/pxelinux.0'];

    $::pkgdefs{csm_bin_copy_tftpboot} = $a_ref;

}

#--------------------------------------------------------------------------------

=head3	default_tftp_server_pkg_name

	Default TFTP Server RPM Name

	Notes :

=cut

#--------------------------------------------------------------------------------
{

    my $a_ref = ['tftp-hpa-0.34-1'];

    $::pkgdefs{default_tftp_server_pkg_name} = $a_ref;

}

#--------------------------------------------------------------------------------

=head3	logfiles

	CSM Log files ( used while uninstalling)

	Notes :

=cut

#--------------------------------------------------------------------------------
{

    my $lf_ref;

    $lf_ref{$_server_} = [
                          '/var/log/csm/csmsetupks.log*',
                          '/var/log/csm/installnode.log*',
                          '/var/log/csm/updatenode.log*',
                          '/var/log/csm/installms.log*'
                          ];

    $lf_ref{$_node_} = ['/var/log/csm/install.log*', '/var/opt/csm/cfmlocal*'];

    $::pkgdefs{logfiles} = $lf_ref{$::mgmt_type};

}

#--------------------------------------------------------------------------------

=head3	rmc_thin_client_binaries

	files needed for RMC the thin client which is used by the nodes to
	communicate to the MS during install.


	Notes :

=cut

#--------------------------------------------------------------------------------
{

    my $a_ref = [
                 "/usr/sbin/rsct/lib/libct_mc.so",
                 "/usr/sbin/rsct/lib/libct_cu.so",
                 "/usr/sbin/rsct/lib/libct_tr.so",
                 "/usr/sbin/rsct/lib/libct_pmsg.so",
                 "/usr/sbin/rsct/lib/libct_sec.so",
                 "/usr/sbin/rsct/lib/libct_idm.so",
                 "/usr/sbin/rsct/lib/libct_ffdc.so",
                 "/usr/sbin/rsct/cfg/ctsec.cfg",
                 "/usr/sbin/rsct/bin/runact-api",
                 "/opt/csm/csmbin/nodestatus.client"
                 ];

    $::pkgdefs{rmc_thin_client_binaries} = $a_ref;

}

#--------------------------------------------------------------------------------

=head3  pkgdefs defaults

        some requred support is not defined for all platforms and archs;
        these defaults are here to ensure that the data coming out of
        pkgdefs is consistent, regardless of the specific distributiion


        Notes :

=cut

#--------------------------------------------------------------------------------
{
    my $empty_ref = [];


    $::pkgdefs{getmacs_Exec}         = $empty_ref;      # getmacs
    $::pkgdefs{getmacs_Lib}          = $empty_ref;
    $::pkgdefs{getmacs_ReqLibs}      = $empty_ref;
    $::pkgdefs{getmacs_DirStructure} = $empty_ref;
    #$::pkgdefs{sp_disks}{QU1}        = $empty_ref;      # sp_disks
    #$::pkgdefs{sp_disks}{QU2}        = $empty_ref;

}

#--------------------------------------------------------------------------------

=head3	linux_diskid_match_prog

	default sub routine for matching linux distribution CD

	Notes :

=cut

#--------------------------------------------------------------------------------

sub linux_diskid_match_prog
{

    my ($base_dir, $ref) = @_;
    my ($key, $file, $orig_dir);

    $file = $ref->{file};
    $key  = $ref->{key};

    if (!-e "$base_dir/$file") { return 0; }

    NodeUtils->runcmd("$::GREP \"$key\" $base_dir/$file", -1);
    if ($::RUNCMD_RC) { return 0; }

    return 1;
}

#--------------------------------------------------------------------------------

=head3	rhel3_diskid_match_prog

	Notes :

=cut

#--------------------------------------------------------------------------------

sub rhel3_diskid_match_prog
{
    my ($base_dir, $ref) = @_;
    my ($orig_dir, $cmd, $file, $num, $rpm, $arch);

    $file = $ref->{file};
    $key  = $ref->{key};
    $num  = $ref->{num};
    $arch = $ref->{arch};
    $rpm  = $ref->{rpm};

    if (!-e "$base_dir/$file") { return 0; }

    NodeUtils->runcmd("$::GREP \"$arch\" $base_dir/$file", -1);
    if ($::RUNCMD_RC) { return 0; }

    NodeUtils->runcmd("$::GREP \"$key\" $base_dir/$file", -1);
    if ($::RUNCMD_RC) { return 0; }

    $cmd = "$::HEAD -n 4 $base_dir/$file|$::TAIL -n 1|$::GREP \"$num\"";
    NodeUtils->runcmd($cmd, -1);
    if ($::RUNCMD_RC) { return 0; }
    if ($rpm ne "")
    {
        NodeUtils->runcmd("$::LS $base_dir/$rpm", -1);
        if ($::RUNCMD_RC) { return 0; }
    }

    return 1;
}

#--------------------------------------------------------------------------------

1;    # end

